/*=========================================================

	heap.h

	q[vƂĎgp郁̈쐬B
	傫̕Ă̂𕡐mۂꍇɗLB
	
	q[v}lWgAPI݂邪AJ[l[hłȂƓȂ̂ƁA
	sceKernelDeleteHeap()Ɍs̃t[YNƂ邽߁AOŁB
	
	Ƃ͂A܂ƂȎɂ悤Ƃƌ\ςȂ̂ŁAƂ肠ۂB
	̂Ƃ둬xʂ͖B

=========================================================*/
#ifndef HEAP_H
#define HEAP_H

#include <pspkernel.h>
#include <pspsysmem_kernel.h>
#include <string.h>
#include "psp/memory.h"
#include "cgerrs.h"

/*=========================================================
	}N
=========================================================*/
#define HEAP_HEADER_SIZE sizeof( struct heap_allocated_memblock_header )

#ifdef __cplusplus
extern "C" {
#endif

/*=========================================================
	^錾
=========================================================*/
typedef uintptr_t HeapUID;

struct heap_allocated_memblock_header {
	SceSize size;                                /* gpĂ郁TCY(wb_܂) */
	struct heap_allocated_memblock_header *next; /* ̎gpubNAhX */
};

/*=========================================================
	֐
=========================================================*/

/*-----------------------------------------------
	heapCreateEx
	
	q[vƂĎgp郁̈mۂB
	wb_KvƂ邽߁AmۂTCY͎w肵TCYwb_TCY(HEAP_HEADER_SIZE)傫ȂB
	
	@param: const char *name
		ubNB
	
	@param: MemoryPartition partition
		mۂp[eBVB
	
	@param: SceSize size
		q[vƂĎgpTCYB
	
	@return: HeapUID
		q[vg߂UIDB
-----------------------------------------------*/
HeapUID heapCreateEx( const char *name, MemoryPartition partition, unsigned int align, SceSize size, int type, void *addr );

/*-----------------------------------------------
	heapCreate
	
	q[vƂĎgp郁̈mۂB
	̊֐͓heapCreateEx()ĂԁB
	mۂ郁p[eBVMEMORY_USERŌŒB
	
	@param: SceSize size
		q[vƂĎgpTCYB
	
	@return: HeapUID
		q[vg߂UIDB
-----------------------------------------------*/
HeapUID heapCreate( SceSize size );

/*-----------------------------------------------
	heapDestroy
	
	mۂq[vB
	q[v̈Ŝ邽߁AheapAlloc()Ŋ蓖ĂĂ郁݂ĂA
	킹ĂׂĉB
	śÃq[vAhXɑ΂ăANZXĂ͂ȂB
	
	@param: HeapUID uid
		heapCreate/heapCreateEx̕ԂlB
-----------------------------------------------*/
void heapDestroy( HeapUID uid );

/*-----------------------------------------------
	heapAlloc
	
	q[vKvȃTCỸXg[W擾B
	Aq[vmۂTCÝAw肵TCYɃwb_TCY(HEAP_HEADER_SIZE)TCYɂȂB
	
	@param: HeapUID uid
		heapCreate/heapCreateEx̕ԂlB
	
	@param: SceSize size
		蓖ĂTCYB
	
	@return: void *
		mۂubNw|C^B
-----------------------------------------------*/
void *heapAlloc( HeapUID uid, SceSize size );

/*-----------------------------------------------
	heapCalloc
	
	q[vKvȃTCỸXg[W擾B
	Aq[vmۂTCÝAw肵TCYɃwb_TCY(HEAP_HEADER_SIZE)TCYɂȂB
	heapAlloc()ƓƂ邪AmیɑΏۃubN[NA_قȂB
	
	@param: HeapUID uid
		heapCreate/heapCreateEx̕ԂlB
	
	@param: SceSize size
		蓖ĂTCYB
	
	@return: void *
		mۂubNw|C^B
-----------------------------------------------*/
void *heapCalloc( HeapUID uid, SceSize size );

/*-----------------------------------------------
	heapFree
	
	heapAlloc()/heapCalloc()ŊmۂubNAėp\ɂB
	ꂽubN͍Ăуq[vƂĎgƂoB
	
	q[v̂̂KvȂꍇheapDestroy()Ăׂ΂悢A
	̏ꍇAmۂĂ郁ubN悤ƂheapFree()ĂԕKv͂ȂB
	heapDestroy()sƁÃq[vmۂĂ郁ubN͑SĉB
-----------------------------------------------*/
int heapFree( HeapUID uid, void *heap );

/*-----------------------------------------------
	heapUsableSize
	
	heapCreate()/heapCreateEx()Ŋmۂq[v̈悪A
	ۂɂǂꂾ̃TCYgp\擾B
	
	@param: HeapUID uid
		heapCreate/heapCreateEx̕ԂlB
	
	@return: SceSize
		gp\ȃoCgB
-----------------------------------------------*/
SceSize heapUsableSize( HeapUID uid );

/*-----------------------------------------------
	heapMaxFreeSize
	
	heapCreate()/heapCreateEx()Ŋmۂq[v̈ŁA
	Ƃ傫ȋ󂫗eʂԂB
	
	@param: HeapUID uid
		heapCreate/heapCreateEx̕ԂlB
	
	@return: SceSize
		Ƃ傫ȋ󂫗eʁB
-----------------------------------------------*/
SceSize heapMaxFreeSize( HeapUID uid );

/*-----------------------------------------------
	heapTotalFreeSize
	
	heapCreate()/heapCreateEx()Ŋmۂq[v̈ɁA
	voCg̋󂫗eʂ݂邩ԂB
	1000ƂlԂĂĂA1000oCg̘AeʂłƂ͌ȂB
	500500̋󂫗eʂcĂ̂ȂA100̋󂫗eʂ10cĂ̂ȂB
	
	
	@param: HeapUID uid
		heapCreate/heapCreateEx̕ԂlB
	
	@return: SceSize
		󂫗eʂ̍vB
-----------------------------------------------*/
SceSize heapTotalFreeSize( HeapUID uid );

#ifdef __cplusplus
}
#endif

#endif
